/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.14-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: mait_blood
-- ------------------------------------------------------
-- Server version	10.11.14-MariaDB-cll-lve

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `audit_logs`
--

DROP TABLE IF EXISTS `audit_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `data` text DEFAULT NULL COMMENT 'JSON data',
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `action` (`action`),
  KEY `created_at` (`created_at`),
  CONSTRAINT `audit_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_logs`
--

LOCK TABLES `audit_logs` WRITE;
/*!40000 ALTER TABLE `audit_logs` DISABLE KEYS */;
INSERT INTO `audit_logs` VALUES
(1,1,'login','User logged in',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 19:37:53'),
(2,1,'emergency_create','Created emergency request: A+','{\"blood_type\":\"A+\",\"quantity\":\"1\",\"blood_group\":\"whole\",\"latitude\":\"15.640359\",\"longitude\":\"32.483000\",\"search_radius\":\"3\",\"notes\":\"\",\"created_by\":1}','::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 19:57:16'),
(3,1,'logout','User logged out',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 20:00:02'),
(4,1,'login','User logged in',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 20:24:34'),
(5,1,'logout','User logged out',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 20:28:09'),
(6,1,'login','User logged in',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 20:29:19'),
(7,1,'logout','User logged out',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 20:29:47'),
(8,1,'login','User logged in',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 20:37:12'),
(9,1,'emergency_activate','Activated emergency request ID: 1',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:14:58'),
(10,1,'emergency_activate','Activated emergency request ID: 11',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:17:09'),
(11,1,'emergency_close','Closed emergency request ID: 1',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:19:19'),
(12,1,'emergency_create','Created emergency request: A+','{\"blood_type\":\"A+\",\"quantity\":\"1\",\"blood_group\":\"plasma\",\"latitude\":\"15.640359\",\"longitude\":\"32.483000\",\"search_radius\":\"3\",\"notes\":\"v[g\",\"created_by\":1}','::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:20:03'),
(13,1,'emergency_close','Closed emergency request ID: 14',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:20:42'),
(14,1,'emergency_activate','Activated emergency request ID: 6',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:21:35'),
(15,1,'donor_arrived','Marked donor arrival for response ID: 6',NULL,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:28:51'),
(16,1,'settings_update','تم تحديث الإعدادات','{\"hospital_name\":\"\\u0627\\u0644\\u0645\\u0633\\u062a\\u0634\\u0641\\u064a \\u0627\\u0644\\u062a\\u062e\\u0635\\u0635\\u064a\",\"hospital_city\":\"Omdurman\",\"hospital_country\":\"United States\",\"hospital_address\":\"\\u0627\\u0644\\u0633\\u0648\\u062f\\u0627\\u0646 , \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0634\\u0645\\u0627\\u0644\\u064a\\u0629 , \\u062f\\u0646\\u0642\\u0644\\u0627\",\"hospital_phone\":\"+966 11 123 4567\",\"hospital_email\":\"info@bloodbank.com\",\"hospital_telegram\":\"https:\\/\\/t.me\\/+ryijGJf19tQxZDJk\",\"telegram_group_chat_id\":\"\",\"working_hours_weekdays\":\"\\u0627\\u0644\\u0623\\u062d\\u062f - \\u0627\\u0644\\u062e\\u0645\\u064a\\u0633: 8:00 \\u0635 - 5:00 \\u0645\",\"working_hours_weekend\":\"\\u0627\\u0644\\u062c\\u0645\\u0639\\u0629 - \\u0627\\u0644\\u0633\\u0628\\u062a: \\u0645\\u063a\\u0644\\u0642\"}','::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:38:38'),
(17,1,'settings_update','تم تحديث الإعدادات','{\"hospital_name\":\"\\u0627\\u0644\\u0645\\u0633\\u062a\\u0634\\u0641\\u064a \\u0627\\u0644\\u062a\\u062e\\u0635\\u0635\\u064a\",\"hospital_city\":\"Omdurman\",\"hospital_country\":\"United States\",\"hospital_address\":\"\\u0627\\u0644\\u0633\\u0648\\u062f\\u0627\\u0646 , \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0634\\u0645\\u0627\\u0644\\u064a\\u0629 , \\u062f\\u0646\\u0642\\u0644\\u0627\",\"hospital_phone\":\"+966 11 123 4567\",\"hospital_email\":\"info@bloodbank.com\",\"hospital_telegram\":\"https:\\/\\/t.me\\/+ryijGJf19tQxZDJk\",\"telegram_group_chat_id\":\"\",\"working_hours_weekdays\":\"\\u0627\\u0644\\u0623\\u062d\\u062f - \\u0627\\u0644\\u062e\\u0645\\u064a\\u0633: 8:00 \\u0635 - 5:00 \\u0645\",\"working_hours_weekend\":\"\\u0627\\u0644\\u062c\\u0645\\u0639\\u0629 - \\u0627\\u0644\\u0633\\u0628\\u062a: \\u0645\\u063a\\u0644\\u0642\"}','::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 21:39:31'),
(18,1,'backup_created','تم إنشاء نسخة احتياطية: backup_2025-12-23_23-26-17.sql.zip','{\"backup_id\":\"1\",\"filename\":\"backup_2025-12-23_23-26-17.sql.zip\",\"size\":7600}','::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','2025-12-23 23:26:18'),
(19,1,'backup_created','Weekly backup created successfully: backup_2025-12-24_06-21-52.sql.zip','{\"backup_id\":\"2\",\"filename\":\"backup_2025-12-24_06-21-52.sql.zip\",\"size\":7729,\"type\":\"weekly_automatic\"}','46.101.70.221','Mozilla/5.0 (Linux, Android 10, K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Mobile Safari/537.36','2025-12-24 06:21:52'),
(20,1,'backup_created','Weekly backup created successfully: backup_2025-12-24_07-01-37.sql.zip','{\"backup_id\":\"3\",\"filename\":\"backup_2025-12-24_07-01-37.sql.zip\",\"size\":7959,\"type\":\"weekly_automatic\"}','74.7.227.16','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; GPTBot/1.3; +https://openai.com/gptbot)','2025-12-24 07:01:37'),
(21,1,'backup_created','Weekly backup created successfully: backup_2025-12-24_07-04-06.sql.zip','{\"backup_id\":\"4\",\"filename\":\"backup_2025-12-24_07-04-06.sql.zip\",\"size\":8072,\"type\":\"weekly_automatic\"}','74.7.227.158','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; GPTBot/1.3; +https://openai.com/gptbot)','2025-12-24 07:04:06');
/*!40000 ALTER TABLE `audit_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `original_filename` varchar(255) DEFAULT NULL,
  `filepath` varchar(500) NOT NULL,
  `size` bigint(20) NOT NULL,
  `description` text DEFAULT NULL,
  `type` enum('database','files','full') DEFAULT 'database',
  `created_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `created_at` (`created_at`),
  CONSTRAINT `fk_backup_user` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` VALUES
(1,'backup_2025-12-23_23-26-17.sql.zip','backup_2025-12-23_23-26-17.sql','C:\\laragon\\www\\blood\\app\\services/../../storage/backups/backup_2025-12-23_23-26-17.sql.zip',7600,'','database',1,'2025-12-24 01:26:18'),
(2,'backup_2025-12-24_06-21-52.sql.zip','backup_2025-12-24_06-21-52.sql','/home/mait/blood.maitech.sd/app/services/../../storage/backups/backup_2025-12-24_06-21-52.sql.zip',7729,'نسخة احتياطية أسبوعية تلقائية - 2025-12-24','database',NULL,'2025-12-24 06:21:52'),
(3,'backup_2025-12-24_07-01-37.sql.zip','backup_2025-12-24_07-01-37.sql','/home/mait/blood.maitech.sd/app/services/../../storage/backups/backup_2025-12-24_07-01-37.sql.zip',7959,'نسخة احتياطية أسبوعية تلقائية - 2025-12-24','database',NULL,'2025-12-24 07:01:37'),
(4,'backup_2025-12-24_07-04-06.sql.zip','backup_2025-12-24_07-04-06.sql','/home/mait/blood.maitech.sd/app/services/../../storage/backups/backup_2025-12-24_07-04-06.sql.zip',8072,'نسخة احتياطية أسبوعية تلقائية - 2025-12-24','database',NULL,'2025-12-24 07:04:06');
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blood_units`
--

DROP TABLE IF EXISTS `blood_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `blood_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit_number` varchar(20) NOT NULL,
  `donation_id` int(11) DEFAULT NULL,
  `blood_type` enum('A+','A-','B+','B-','AB+','AB-','O+','O-') NOT NULL,
  `blood_group` enum('whole','plasma','platelets','red_cells') NOT NULL DEFAULT 'whole',
  `status` enum('available','reserved','used','discarded') NOT NULL DEFAULT 'available',
  `expiry_date` date NOT NULL,
  `created_at` datetime NOT NULL,
  `reserved_at` datetime DEFAULT NULL,
  `used_at` datetime DEFAULT NULL,
  `discarded_at` datetime DEFAULT NULL,
  `discard_reason` text DEFAULT NULL,
  `emergency_request_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unit_number` (`unit_number`),
  KEY `donation_id` (`donation_id`),
  KEY `blood_type` (`blood_type`),
  KEY `status` (`status`),
  KEY `expiry_date` (`expiry_date`),
  KEY `emergency_request_id` (`emergency_request_id`),
  CONSTRAINT `blood_units_ibfk_1` FOREIGN KEY (`donation_id`) REFERENCES `donations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blood_units`
--

LOCK TABLES `blood_units` WRITE;
/*!40000 ALTER TABLE `blood_units` DISABLE KEYS */;
INSERT INTO `blood_units` VALUES
(1,'BB20240115001',1,'O+','whole','discarded','2024-02-26','2024-01-15 10:35:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(2,'BB20240220001',2,'A+','whole','discarded','2024-04-02','2024-02-20 11:05:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(3,'BB20231210001',3,'B+','whole','used','2024-01-21','2023-12-10 09:50:00',NULL,'2024-01-20 10:00:00',NULL,NULL,NULL),
(4,'BB20240305001',5,'O-','whole','discarded','2024-04-16','2024-03-05 14:25:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(5,'BB20240130001',6,'A-','whole','discarded','2024-03-12','2024-01-30 10:20:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(6,'BB20231125001',7,'B-','whole','discarded','2024-01-06','2023-11-25 13:35:00',NULL,NULL,'2024-01-10 14:00:00','انتهت الصلاحية',NULL),
(7,'BB20240210001',8,'AB-','whole','discarded','2024-03-23','2024-02-10 11:50:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(8,'BB20240315001',9,'O+','whole','reserved','2024-04-26','2024-03-15 15:05:00','2024-03-20 09:00:00',NULL,NULL,NULL,NULL),
(9,'BB20240228001',10,'A+','whole','discarded','2024-04-10','2024-02-28 10:35:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(10,'BB20231220001',11,'B+','whole','discarded','2024-01-31','2023-12-20 12:05:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(11,'BB20240110001',13,'A-','whole','discarded','2024-02-21','2024-01-10 09:35:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(12,'BB20240301001',14,'B-','whole','discarded','2024-04-12','2024-03-01 14:05:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(13,'BB20231115001',15,'AB+','whole','used','2023-12-27','2023-11-15 11:20:00',NULL,'2024-01-05 11:00:00',NULL,NULL,NULL),
(14,'BB20240115002',1,'O+','whole','discarded','2024-02-26','2024-01-15 10:40:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(15,'BB20240220002',2,'A+','whole','discarded','2024-04-02','2024-02-20 11:10:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(16,'BB20240305002',5,'O-','whole','discarded','2024-04-16','2024-03-05 14:30:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(17,'BB20240130002',6,'A-','whole','discarded','2024-03-12','2024-01-30 10:25:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(18,'BB20240210002',8,'AB-','whole','discarded','2024-03-23','2024-02-10 11:55:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(19,'BB20240228002',10,'A+','whole','discarded','2024-04-10','2024-02-28 10:40:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL),
(20,'BB20231220002',11,'B+','whole','discarded','2024-01-31','2023-12-20 12:10:00',NULL,NULL,'2025-12-24 06:21:52','انتهت صلاحية الكيس تلقائياً',NULL);
/*!40000 ALTER TABLE `blood_units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `donations`
--

DROP TABLE IF EXISTS `donations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `donations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_id` int(11) NOT NULL,
  `donation_date` date NOT NULL,
  `blood_group` enum('whole','plasma','platelets','red_cells') NOT NULL DEFAULT 'whole',
  `volume` decimal(5,2) DEFAULT NULL COMMENT 'in ml',
  `donation_location` varchar(255) DEFAULT NULL COMMENT 'مكان التبرع (مثل: المستشفى، مركز التبرع، إلخ)',
  `notes` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `donor_id` (`donor_id`),
  KEY `donation_date` (`donation_date`),
  KEY `created_by` (`created_by`),
  KEY `donation_location` (`donation_location`),
  CONSTRAINT `donations_ibfk_1` FOREIGN KEY (`donor_id`) REFERENCES `donors` (`id`) ON DELETE CASCADE,
  CONSTRAINT `donations_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `donations`
--

LOCK TABLES `donations` WRITE;
/*!40000 ALTER TABLE `donations` DISABLE KEYS */;
INSERT INTO `donations` VALUES
(1,1,'2024-01-15','whole',450.00,NULL,NULL,'2024-01-15 10:30:00',3),
(2,2,'2024-02-20','whole',450.00,NULL,NULL,'2024-02-20 11:00:00',3),
(3,3,'2023-12-10','whole',450.00,NULL,NULL,'2023-12-10 09:45:00',3),
(4,5,'2024-03-05','whole',450.00,NULL,NULL,'2024-03-05 14:20:00',3),
(5,6,'2024-01-30','whole',450.00,NULL,NULL,'2024-01-30 10:15:00',3),
(6,7,'2023-11-25','whole',450.00,NULL,NULL,'2023-11-25 13:30:00',3),
(7,8,'2024-02-10','whole',450.00,NULL,NULL,'2024-02-10 11:45:00',3),
(8,9,'2024-03-15','whole',450.00,NULL,NULL,'2024-03-15 15:00:00',3),
(9,10,'2024-02-28','whole',450.00,NULL,NULL,'2024-02-28 10:30:00',3),
(10,11,'2023-12-20','whole',450.00,NULL,NULL,'2023-12-20 12:00:00',3),
(11,13,'2024-01-10','whole',450.00,NULL,NULL,'2024-01-10 09:30:00',3),
(12,14,'2024-03-01','whole',450.00,NULL,NULL,'2024-03-01 14:00:00',3),
(13,15,'2023-11-15','whole',450.00,NULL,NULL,'2023-11-15 11:15:00',3),
(14,1,'2024-01-15','whole',450.00,NULL,NULL,'2024-01-15 10:30:00',3),
(15,2,'2024-02-20','whole',450.00,NULL,NULL,'2024-02-20 11:00:00',3),
(16,3,'2023-12-10','whole',450.00,NULL,NULL,'2023-12-10 09:45:00',3),
(17,5,'2024-03-05','whole',450.00,NULL,NULL,'2024-03-05 14:20:00',3),
(18,6,'2024-01-30','whole',450.00,NULL,NULL,'2024-01-30 10:15:00',3),
(19,7,'2023-11-25','whole',450.00,NULL,NULL,'2023-11-25 13:30:00',3),
(20,8,'2024-02-10','whole',450.00,NULL,NULL,'2024-02-10 11:45:00',3),
(21,9,'2024-03-15','whole',450.00,NULL,NULL,'2024-03-15 15:00:00',3),
(22,10,'2024-02-28','whole',450.00,NULL,NULL,'2024-02-28 10:30:00',3),
(23,11,'2023-12-20','whole',450.00,NULL,NULL,'2023-12-20 12:00:00',3),
(24,13,'2024-01-10','whole',450.00,NULL,NULL,'2024-01-10 09:30:00',3),
(25,14,'2024-03-01','whole',450.00,NULL,NULL,'2024-03-01 14:00:00',3),
(26,15,'2023-11-15','whole',450.00,NULL,NULL,'2023-11-15 11:15:00',3);
/*!40000 ALTER TABLE `donations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `donors`
--

DROP TABLE IF EXISTS `donors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `donors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `phone_secondary` varchar(20) DEFAULT NULL,
  `telegram_chat_id` varchar(50) DEFAULT NULL,
  `telegram_username` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `national_id` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `age` int(11) DEFAULT NULL,
  `gender` enum('male','female') DEFAULT NULL,
  `last_donation_date` date DEFAULT NULL,
  `has_chronic_diseases` tinyint(1) DEFAULT 0,
  `chronic_diseases_details` text DEFAULT NULL,
  `medications` text DEFAULT NULL,
  `allergies` text DEFAULT NULL,
  `weight` decimal(5,2) DEFAULT NULL COMMENT 'in kg',
  `blood_type` enum('A+','A-','B+','B-','AB+','AB-','O+','O-') NOT NULL,
  `status` enum('active','deferred','inactive') NOT NULL DEFAULT 'active',
  `emergency_consent` tinyint(1) NOT NULL DEFAULT 0,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `location_updated_at` datetime DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `notes_medical` text DEFAULT NULL COMMENT 'Medical notes',
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blood_type` (`blood_type`),
  KEY `status` (`status`),
  KEY `emergency_consent` (`emergency_consent`),
  KEY `location` (`latitude`,`longitude`),
  KEY `phone_secondary` (`phone_secondary`),
  KEY `email` (`email`),
  KEY `national_id` (`national_id`),
  KEY `telegram_chat_id` (`telegram_chat_id`),
  KEY `telegram_username` (`telegram_username`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `donors`
--

LOCK TABLES `donors` WRITE;
/*!40000 ALTER TABLE `donors` DISABLE KEYS */;
INSERT INTO `donors` VALUES
(1,'محمد أحمد العلي','0501234567','0551234567',NULL,NULL,'mohammed.ali@example.com',NULL,'حي النرجس، شارع الملك فهد','الرياض',28,'male','2024-01-15',0,NULL,NULL,NULL,NULL,'O+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(2,'فاطمة سعد الدوسري','0502345678',NULL,NULL,NULL,'fatima.dosari@example.com',NULL,'حي العليا، شارع التحلية','الرياض',25,'female','2024-02-20',0,NULL,NULL,NULL,NULL,'A+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(3,'عبدالله خالد المطيري','0503456789','0553456789',NULL,NULL,'abdullah.mutairi@example.com',NULL,'حي الزهراء، شارع التحلية','جدة',32,'male','2023-12-10',0,NULL,NULL,NULL,NULL,'B+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(4,'نورة عبدالرحمن القحطاني','0504567890',NULL,NULL,NULL,'nora.qhtani@example.com',NULL,'حي الفيصلية، شارع الملك خالد','الدمام',27,'female',NULL,0,NULL,NULL,NULL,NULL,'AB+','active',0,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(5,'سالم محمد الحربي','0505678901','0555678901',NULL,NULL,'salem.harbi@example.com',NULL,'حي المطار، شارع العليا','الرياض',35,'male','2024-03-05',0,NULL,NULL,NULL,NULL,'O-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(6,'ريم فهد الشمري','0506789012',NULL,NULL,NULL,'reem.shamri@example.com',NULL,'حي النخيل، شارع العليا','الرياض',23,'female','2024-01-30',0,NULL,NULL,NULL,NULL,'A-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(7,'يوسف عبدالله العتيبي','0507890123','0557890123',NULL,NULL,'yousef.otaibi@example.com',NULL,'حي الروابي، شارع التحلية','جدة',29,'male','2023-11-25',0,NULL,NULL,NULL,NULL,'B-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(8,'لينا سامي الغامدي','0508901234',NULL,NULL,NULL,'lina.ghamdi@example.com',NULL,'حي الشاطئ، شارع الكورنيش','الدمام',26,'female','2024-02-10',0,NULL,NULL,NULL,NULL,'AB-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(9,'خالد إبراهيم الدوسري','0509012345','0559012345',NULL,NULL,'khalid.dosari@example.com',NULL,'حي العليا، شارع التحلية','الرياض',31,'male','2024-03-15',0,NULL,NULL,NULL,NULL,'O+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(10,'هند محمد الزهراني','0500123456',NULL,NULL,NULL,'hind.zahrani@example.com',NULL,'حي الزهراء، شارع التحلية','جدة',24,'female','2024-02-28',0,NULL,NULL,NULL,NULL,'A+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(11,'عمر فهد القحطاني','0501234501','0551234501',NULL,NULL,'omar.qhtani@example.com',NULL,'حي النرجس، شارع الملك فهد','الرياض',33,'male','2023-12-20',0,NULL,NULL,NULL,NULL,'B+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(12,'سارة أحمد المطيري','0502345012',NULL,NULL,NULL,'sara.mutairi@example.com',NULL,'حي الفيصلية، شارع الملك خالد','الدمام',22,'female',NULL,0,NULL,NULL,NULL,NULL,'O-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(13,'طارق سعد العتيبي','0503450123','0553450123',NULL,NULL,'tariq.otaibi@example.com',NULL,'حي المطار، شارع العليا','الرياض',30,'male','2024-01-10',0,NULL,NULL,NULL,NULL,'A-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(14,'مريم خالد الشمري','0504501234',NULL,NULL,NULL,'mariam.shamri@example.com',NULL,'حي الروابي، شارع التحلية','جدة',28,'female','2024-03-01',0,NULL,NULL,NULL,NULL,'B-','active',0,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(15,'نواف عبدالله الغامدي','0505012345','0555012345',NULL,NULL,'nawaf.ghamdi@example.com',NULL,'حي النخيل، شارع العليا','الرياض',36,'male','2023-11-15',0,NULL,NULL,NULL,NULL,'AB+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:55:52',NULL),
(16,'محمد أحمد العلي','0501234567','0551234567',NULL,NULL,'mohammed.ali@example.com',NULL,'حي النرجس، شارع الملك فهد','الرياض',28,'male','2024-01-15',0,NULL,NULL,NULL,NULL,'O+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(17,'فاطمة سعد الدوسري','0502345678',NULL,NULL,NULL,'fatima.dosari@example.com',NULL,'حي العليا، شارع التحلية','الرياض',25,'female','2024-02-20',0,NULL,NULL,NULL,NULL,'A+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(18,'عبدالله خالد المطيري','0503456789','0553456789',NULL,NULL,'abdullah.mutairi@example.com',NULL,'حي الزهراء، شارع التحلية','جدة',32,'male','2023-12-10',0,NULL,NULL,NULL,NULL,'B+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(19,'نورة عبدالرحمن القحطاني','0504567890',NULL,NULL,NULL,'nora.qhtani@example.com',NULL,'حي الفيصلية، شارع الملك خالد','الدمام',27,'female',NULL,0,NULL,NULL,NULL,NULL,'AB+','active',0,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(20,'سالم محمد الحربي','0505678901','0555678901',NULL,NULL,'salem.harbi@example.com',NULL,'حي المطار، شارع العليا','الرياض',35,'male','2024-03-05',0,NULL,NULL,NULL,NULL,'O-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(21,'ريم فهد الشمري','0506789012',NULL,NULL,NULL,'reem.shamri@example.com',NULL,'حي النخيل، شارع العليا','الرياض',23,'female','2024-01-30',0,NULL,NULL,NULL,NULL,'A-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(22,'يوسف عبدالله العتيبي','0507890123','0557890123',NULL,NULL,'yousef.otaibi@example.com',NULL,'حي الروابي، شارع التحلية','جدة',29,'male','2023-11-25',0,NULL,NULL,NULL,NULL,'B-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(23,'لينا سامي الغامدي','0508901234',NULL,NULL,NULL,'lina.ghamdi@example.com',NULL,'حي الشاطئ، شارع الكورنيش','الدمام',26,'female','2024-02-10',0,NULL,NULL,NULL,NULL,'AB-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(24,'خالد إبراهيم الدوسري','0509012345','0559012345',NULL,NULL,'khalid.dosari@example.com',NULL,'حي العليا، شارع التحلية','الرياض',31,'male','2024-03-15',0,NULL,NULL,NULL,NULL,'O+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(25,'هند محمد الزهراني','0500123456',NULL,NULL,NULL,'hind.zahrani@example.com',NULL,'حي الزهراء، شارع التحلية','جدة',24,'female','2024-02-28',0,NULL,NULL,NULL,NULL,'A+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(26,'عمر فهد القحطاني','0501234501','0551234501',NULL,NULL,'omar.qhtani@example.com',NULL,'حي النرجس، شارع الملك فهد','الرياض',33,'male','2023-12-20',0,NULL,NULL,NULL,NULL,'B+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(27,'سارة أحمد المطيري','0502345012',NULL,NULL,NULL,'sara.mutairi@example.com',NULL,'حي الفيصلية، شارع الملك خالد','الدمام',22,'female',NULL,0,NULL,NULL,NULL,NULL,'O-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(28,'طارق سعد العتيبي','0503450123','0553450123',NULL,NULL,'tariq.otaibi@example.com',NULL,'حي المطار، شارع العليا','الرياض',30,'male','2024-01-10',0,NULL,NULL,NULL,NULL,'A-','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(29,'مريم خالد الشمري','0504501234',NULL,NULL,NULL,'mariam.shamri@example.com',NULL,'حي الروابي، شارع التحلية','جدة',28,'female','2024-03-01',0,NULL,NULL,NULL,NULL,'B-','active',0,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL),
(30,'نواف عبدالله الغامدي','0505012345','0555012345',NULL,NULL,'nawaf.ghamdi@example.com',NULL,'حي النخيل، شارع العليا','الرياض',36,'male','2023-11-15',0,NULL,NULL,NULL,NULL,'AB+','active',1,NULL,NULL,NULL,NULL,NULL,'2025-12-23 22:59:40',NULL);
/*!40000 ALTER TABLE `donors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emergency_requests`
--

DROP TABLE IF EXISTS `emergency_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `emergency_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_type` enum('A+','A-','B+','B-','AB+','AB-','O+','O-') NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `blood_group` enum('whole','plasma','platelets','red_cells') NOT NULL DEFAULT 'whole',
  `latitude` decimal(10,8) NOT NULL,
  `longitude` decimal(11,8) NOT NULL,
  `search_radius` decimal(5,2) NOT NULL DEFAULT 3.00 COMMENT 'in km',
  `status` enum('open','active','closed') NOT NULL DEFAULT 'open',
  `priority` enum('normal','urgent') NOT NULL DEFAULT 'normal',
  `notes` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `activated_at` datetime DEFAULT NULL,
  `closed_at` datetime DEFAULT NULL,
  `closure_reason` enum('success','failed','cancelled') DEFAULT NULL,
  `closure_notes` text DEFAULT NULL,
  `radius_expanded_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blood_type` (`blood_type`),
  KEY `status` (`status`),
  KEY `created_by` (`created_by`),
  KEY `location` (`latitude`,`longitude`),
  KEY `priority` (`priority`),
  CONSTRAINT `emergency_requests_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emergency_requests`
--

LOCK TABLES `emergency_requests` WRITE;
/*!40000 ALTER TABLE `emergency_requests` DISABLE KEYS */;
INSERT INTO `emergency_requests` VALUES
(1,'A+',1,'whole',15.64035900,32.48300000,5.00,'closed','normal','',1,'2025-12-23 19:56:05','2025-12-23 21:14:58','2025-12-23 21:19:19',NULL,NULL,'2025-12-23 21:14:58'),
(2,'A+',1,'whole',15.64035900,32.48300000,3.00,'open','normal','',1,'2025-12-23 19:56:51',NULL,NULL,NULL,NULL,NULL),
(3,'A+',1,'whole',15.64035900,32.48300000,5.00,'active','normal','',1,'2025-12-23 19:57:16','2025-12-23 19:57:16',NULL,NULL,NULL,'2025-12-23 19:57:16'),
(4,'O+',2,'whole',24.71360000,46.67530000,3.00,'closed','normal','حالة طوارئ - حادث مروري',2,'2024-03-10 08:30:00','2024-03-10 08:35:00','2024-03-15 18:00:00',NULL,NULL,NULL),
(5,'A+',1,'whole',24.71360000,46.67530000,5.00,'active','normal','عملية جراحية عاجلة',2,'2024-03-20 14:00:00','2024-03-20 14:05:00',NULL,NULL,NULL,NULL),
(6,'B+',3,'whole',21.48580000,39.19250000,5.00,'active','normal','حالة نزيف حاد',2,'2024-03-22 10:15:00','2025-12-23 21:21:35',NULL,NULL,NULL,'2025-12-23 21:21:35'),
(7,'O-',1,'whole',24.71360000,46.67530000,4.00,'closed','normal','حالة طوارئ - تم الحل',2,'2024-03-15 16:20:00','2024-03-15 16:25:00',NULL,NULL,NULL,NULL),
(8,'AB+',2,'whole',21.48580000,39.19250000,4.00,'active','normal','عملية قلب مفتوح',2,'2024-03-21 09:00:00','2024-03-21 09:05:00',NULL,NULL,NULL,'2025-12-23 21:18:58'),
(9,'O+',2,'whole',24.71360000,46.67530000,3.00,'closed','normal','حالة طوارئ - حادث مروري',2,'2024-03-10 08:30:00','2024-03-10 08:35:00',NULL,NULL,NULL,NULL),
(10,'A+',1,'whole',24.71360000,46.67530000,5.00,'active','normal','عملية جراحية عاجلة',2,'2024-03-20 14:00:00','2024-03-20 14:05:00',NULL,NULL,NULL,NULL),
(11,'B+',3,'whole',21.48580000,39.19250000,5.00,'active','normal','حالة نزيف حاد',2,'2024-03-22 10:15:00','2025-12-23 21:17:09',NULL,NULL,NULL,'2025-12-23 21:17:09'),
(12,'O-',1,'whole',24.71360000,46.67530000,4.00,'closed','normal','حالة طوارئ - تم الحل',2,'2024-03-15 16:20:00','2024-03-15 16:25:00',NULL,NULL,NULL,NULL),
(13,'AB+',2,'whole',21.48580000,39.19250000,3.00,'active','normal','عملية قلب مفتوح',2,'2024-03-21 09:00:00','2024-03-21 09:05:00',NULL,NULL,NULL,NULL),
(14,'A+',1,'plasma',15.64035900,32.48300000,5.00,'closed','normal','v[g',1,'2025-12-23 21:20:02','2025-12-23 21:20:03','2025-12-23 21:20:42',NULL,NULL,'2025-12-23 21:20:03');
/*!40000 ALTER TABLE `emergency_requests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emergency_responses`
--

DROP TABLE IF EXISTS `emergency_responses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `emergency_responses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `request_id` int(11) NOT NULL,
  `donor_id` int(11) NOT NULL,
  `status` enum('pending','accepted','rejected','completed') NOT NULL DEFAULT 'pending',
  `response_time` datetime NOT NULL,
  `accepted_at` datetime DEFAULT NULL,
  `arrived_at` datetime DEFAULT NULL,
  `arrival_notes` text DEFAULT NULL,
  `rejected_at` datetime DEFAULT NULL,
  `completed_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_response` (`request_id`,`donor_id`),
  KEY `request_id` (`request_id`),
  KEY `donor_id` (`donor_id`),
  KEY `status` (`status`),
  CONSTRAINT `emergency_responses_ibfk_1` FOREIGN KEY (`request_id`) REFERENCES `emergency_requests` (`id`) ON DELETE CASCADE,
  CONSTRAINT `emergency_responses_ibfk_2` FOREIGN KEY (`donor_id`) REFERENCES `donors` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emergency_responses`
--

LOCK TABLES `emergency_responses` WRITE;
/*!40000 ALTER TABLE `emergency_responses` DISABLE KEYS */;
INSERT INTO `emergency_responses` VALUES
(1,1,1,'accepted','2024-03-10 08:40:00','2024-03-10 08:40:00',NULL,NULL,NULL,NULL),
(2,1,5,'accepted','2024-03-10 08:45:00','2024-03-10 08:45:00',NULL,NULL,NULL,NULL),
(3,2,2,'accepted','2024-03-20 14:10:00','2024-03-20 14:10:00',NULL,NULL,NULL,NULL),
(4,3,3,'pending','2024-03-22 10:30:00',NULL,NULL,NULL,NULL,NULL),
(5,4,5,'accepted','2024-03-15 16:30:00','2024-03-15 16:30:00',NULL,NULL,NULL,NULL),
(6,5,8,'accepted','2024-03-21 09:15:00','2024-03-21 09:15:00','2025-12-23 21:28:51','وصل المتبرع',NULL,NULL),
(7,5,15,'accepted','2024-03-21 09:20:00','2024-03-21 09:20:00',NULL,NULL,NULL,NULL),
(8,2,6,'rejected','2024-03-20 14:15:00',NULL,NULL,NULL,'2024-03-20 14:15:00',NULL),
(9,5,10,'pending','2024-03-21 09:25:00',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `emergency_responses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_alerts`
--

DROP TABLE IF EXISTS `inventory_alerts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_alerts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alert_type` enum('low_stock','critical_stock','expiring_soon','expired') NOT NULL,
  `blood_type` enum('A+','A-','B+','B-','AB+','AB-','O+','O-') NOT NULL,
  `severity` enum('info','warning','critical','danger') NOT NULL DEFAULT 'warning',
  `message` text NOT NULL,
  `alert_data` text DEFAULT NULL COMMENT 'JSON data with additional alert information',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=active, 0=dismissed/hidden',
  `is_read` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1=read by user, 0=unread',
  `dismissed_by` int(11) DEFAULT NULL COMMENT 'User who dismissed the alert',
  `dismissed_at` datetime DEFAULT NULL,
  `read_by` int(11) DEFAULT NULL COMMENT 'User who read the alert',
  `read_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `alert_type` (`alert_type`),
  KEY `blood_type` (`blood_type`),
  KEY `severity` (`severity`),
  KEY `is_active` (`is_active`),
  KEY `is_read` (`is_read`),
  KEY `dismissed_by` (`dismissed_by`),
  KEY `read_by` (`read_by`),
  CONSTRAINT `inventory_alerts_ibfk_1` FOREIGN KEY (`dismissed_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `inventory_alerts_ibfk_2` FOREIGN KEY (`read_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_alerts`
--

LOCK TABLES `inventory_alerts` WRITE;
/*!40000 ALTER TABLE `inventory_alerts` DISABLE KEYS */;
INSERT INTO `inventory_alerts` VALUES
(1,'expired','O-','danger','2 وحدة من فصيلة O- منتهية الصلاحية','{\"blood_type\":\"O-\",\"count\":2,\"severity\":\"danger\",\"message\":\"2 وحدة من فصيلة O- منتهية الصلاحية\",\"units\":[{\"id\":4,\"unit_number\":\"BB20240305001\",\"donation_id\":5,\"blood_type\":\"O-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-04-16\",\"created_at\":\"2024-03-05 14:25:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"ريم فهد الشمري\"},{\"id\":16,\"unit_number\":\"BB20240305002\",\"donation_id\":5,\"blood_type\":\"O-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-04-16\",\"created_at\":\"2024-03-05 14:30:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"ريم فهد الشمري\"}]}',1,0,NULL,NULL,NULL,NULL,'2025-12-23 23:00:38','2025-12-24 00:02:20'),
(2,'expired','B-','danger','1 وحدة من فصيلة B- منتهية الصلاحية','{\"blood_type\":\"B-\",\"count\":1,\"severity\":\"danger\",\"message\":\"1 وحدة من فصيلة B- منتهية الصلاحية\",\"units\":[{\"id\":12,\"unit_number\":\"BB20240301001\",\"donation_id\":14,\"blood_type\":\"B-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-04-12\",\"created_at\":\"2024-03-01 14:05:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"محمد أحمد العلي\"}]}',0,0,1,'2025-12-23 23:05:58',NULL,NULL,'2025-12-23 23:00:39','2025-12-23 23:05:58'),
(3,'expired','A+','danger','4 وحدة من فصيلة A+ منتهية الصلاحية','{\"blood_type\":\"A+\",\"count\":4,\"severity\":\"danger\",\"message\":\"4 وحدة من فصيلة A+ منتهية الصلاحية\",\"units\":[{\"id\":9,\"unit_number\":\"BB20240228001\",\"donation_id\":10,\"blood_type\":\"A+\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-04-10\",\"created_at\":\"2024-02-28 10:35:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"عمر فهد القحطاني\"},{\"id\":19,\"unit_number\":\"BB20240228002\",\"donation_id\":10,\"blood_type\":\"A+\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-04-10\",\"created_at\":\"2024-02-28 10:40:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"عمر فهد القحطاني\"},{\"id\":2,\"unit_number\":\"BB20240220001\",\"donation_id\":2,\"blood_type\":\"A+\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-04-02\",\"created_at\":\"2024-02-20 11:05:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"فاطمة سعد الدوسري\"},{\"id\":15,\"unit_number\":\"BB20240220002\",\"donation_id\":2,\"blood_type\":\"A+\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-04-02\",\"created_at\":\"2024-02-20 11:10:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"فاطمة سعد الدوسري\"}]}',1,0,NULL,NULL,NULL,NULL,'2025-12-23 23:00:39','2025-12-24 00:02:20'),
(4,'expired','AB-','danger','2 وحدة من فصيلة AB- منتهية الصلاحية','{\"blood_type\":\"AB-\",\"count\":2,\"severity\":\"danger\",\"message\":\"2 وحدة من فصيلة AB- منتهية الصلاحية\",\"units\":[{\"id\":7,\"unit_number\":\"BB20240210001\",\"donation_id\":8,\"blood_type\":\"AB-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-03-23\",\"created_at\":\"2024-02-10 11:50:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"خالد إبراهيم الدوسري\"},{\"id\":18,\"unit_number\":\"BB20240210002\",\"donation_id\":8,\"blood_type\":\"AB-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-03-23\",\"created_at\":\"2024-02-10 11:55:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"خالد إبراهيم الدوسري\"}]}',1,0,NULL,NULL,NULL,NULL,'2025-12-23 23:00:39','2025-12-24 00:02:20'),
(5,'expired','A-','danger','3 وحدة من فصيلة A- منتهية الصلاحية','{\"blood_type\":\"A-\",\"count\":3,\"severity\":\"danger\",\"message\":\"3 وحدة من فصيلة A- منتهية الصلاحية\",\"units\":[{\"id\":5,\"unit_number\":\"BB20240130001\",\"donation_id\":6,\"blood_type\":\"A-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-03-12\",\"created_at\":\"2024-01-30 10:20:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"يوسف عبدالله العتيبي\"},{\"id\":17,\"unit_number\":\"BB20240130002\",\"donation_id\":6,\"blood_type\":\"A-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-03-12\",\"created_at\":\"2024-01-30 10:25:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"يوسف عبدالله العتيبي\"},{\"id\":11,\"unit_number\":\"BB20240110001\",\"donation_id\":13,\"blood_type\":\"A-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-02-21\",\"created_at\":\"2024-01-10 09:35:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"نواف عبدالله الغامدي\"}]}',1,0,NULL,NULL,NULL,NULL,'2025-12-23 23:00:39','2025-12-24 00:02:20'),
(6,'expired','O+','danger','2 وحدة من فصيلة O+ منتهية الصلاحية','{\"blood_type\":\"O+\",\"count\":2,\"severity\":\"danger\",\"message\":\"2 وحدة من فصيلة O+ منتهية الصلاحية\",\"units\":[{\"id\":1,\"unit_number\":\"BB20240115001\",\"donation_id\":1,\"blood_type\":\"O+\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-02-26\",\"created_at\":\"2024-01-15 10:35:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"محمد أحمد العلي\"},{\"id\":14,\"unit_number\":\"BB20240115002\",\"donation_id\":1,\"blood_type\":\"O+\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-02-26\",\"created_at\":\"2024-01-15 10:40:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"محمد أحمد العلي\"}]}',1,0,NULL,NULL,NULL,NULL,'2025-12-23 23:00:39','2025-12-24 00:02:20'),
(7,'expired','B+','danger','2 وحدة من فصيلة B+ منتهية الصلاحية','{\"blood_type\":\"B+\",\"count\":2,\"severity\":\"danger\",\"message\":\"2 وحدة من فصيلة B+ منتهية الصلاحية\",\"units\":[{\"id\":10,\"unit_number\":\"BB20231220001\",\"donation_id\":11,\"blood_type\":\"B+\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-01-31\",\"created_at\":\"2023-12-20 12:05:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"طارق سعد العتيبي\"},{\"id\":20,\"unit_number\":\"BB20231220002\",\"donation_id\":11,\"blood_type\":\"B+\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-01-31\",\"created_at\":\"2023-12-20 12:10:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"طارق سعد العتيبي\"}]}',1,0,NULL,NULL,NULL,NULL,'2025-12-23 23:00:39','2025-12-24 00:02:20'),
(8,'expired','B-','danger','1 وحدة من فصيلة B- منتهية الصلاحية','{\"blood_type\":\"B-\",\"count\":1,\"severity\":\"danger\",\"message\":\"1 وحدة من فصيلة B- منتهية الصلاحية\",\"units\":[{\"id\":12,\"unit_number\":\"BB20240301001\",\"donation_id\":14,\"blood_type\":\"B-\",\"blood_group\":\"whole\",\"status\":\"available\",\"expiry_date\":\"2024-04-12\",\"created_at\":\"2024-03-01 14:05:00\",\"reserved_at\":null,\"used_at\":null,\"discarded_at\":null,\"discard_reason\":null,\"emergency_request_id\":null,\"donor_name\":\"محمد أحمد العلي\"}]}',0,0,1,'2025-12-23 23:06:55',NULL,NULL,'2025-12-23 23:05:58','2025-12-23 23:06:55');
/*!40000 ALTER TABLE `inventory_alerts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notification_logs`
--

DROP TABLE IF EXISTS `notification_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('sms','whatsapp','email') NOT NULL,
  `recipient` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `status` enum('sent','failed','pending') NOT NULL DEFAULT 'pending',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notification_logs`
--

LOCK TABLES `notification_logs` WRITE;
/*!40000 ALTER TABLE `notification_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `notification_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(100) NOT NULL,
  `value` text DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`),
  KEY `updated_by` (`updated_by`),
  CONSTRAINT `settings_ibfk_1` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES
(1,'hospital_name','المستشفي التخصصي',NULL,'2025-12-23 23:39:31',1),
(2,'hospital_address','السودان , الولاية الشمالية , دنقلا',NULL,'2025-12-23 23:39:31',1),
(3,'hospital_phone','+966 11 123 4567',NULL,'2025-12-23 23:39:31',1),
(4,'hospital_email','info@bloodbank.com',NULL,'2025-12-23 23:39:31',1),
(5,'hospital_telegram','https://t.me/+ryijGJf19tQxZDJk',NULL,'2025-12-23 23:39:31',1),
(6,'working_hours_weekdays','الأحد - الخميس: 8:00 ص - 5:00 م',NULL,'2025-12-23 23:39:31',1),
(7,'working_hours_weekend','الجمعة - السبت: مغلق',NULL,'2025-12-23 23:39:31',1),
(8,'hospital_city','Omdurman',NULL,'2025-12-23 23:39:31',1),
(9,'hospital_country','United States',NULL,'2025-12-23 23:39:31',1),
(10,'telegram_group_chat_id','',NULL,'2025-12-23 23:39:31',1);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `role` enum('admin','doctor','lab','emergency_staff') NOT NULL DEFAULT 'emergency_staff',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `created_at` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES
(1,'admin','$2y$10$btAQONzYbkzvY3vBwZlSLeTndBKBVN5uNGDVCKoYQvJg3WRqUb2r.','مدير النظام','admin','active','2025-12-23 19:35:10','2025-12-23 20:37:12'),
(2,'doctor1','$2y$12$LQv3c1yqBWVHxkd0LHAkCOYz6TtxMQJqhN8/LewY5GyYqJ5q5q5q.','د. أحمد محمد','doctor','active','2025-12-23 22:55:52',NULL),
(3,'lab1','$2y$12$LQv3c1yqBWVHxkd0LHAkCOYz6TtxMQJqhN8/LewY5GyYqJ5q5q5q.','فني مختبر - سارة','lab','active','2025-12-23 22:55:52',NULL),
(4,'emergency1','$2y$12$LQv3c1yqBWVHxkd0LHAkCOYz6TtxMQJqhN8/LewY5GyYqJ5q5q5q.','موظف طوارئ - خالد','emergency_staff','active','2025-12-23 22:55:52',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-24 13:22:24
